definition module EdLists;

import EdTypes;

Singleton :: !(List t) -> t;
IsEmptyList	:: !(List t) -> Bool;
Head :: !(List t) -> t;
Concat :: !(List t) !(List t) -> List t;
Reverse	:: !(List t) -> List t;
Reverse2 :: !(List t) !(List t) -> List t;
LLength :: !(List t) -> Int;
MapR	:: !(s -> t) !(List s) -> List t;
FilterR :: (s -> Bool) !(List s) -> List s;
Filter :: (s -> Bool) !(List s) -> List s;
Append :: !(List t) !t -> List t;
Select :: !(List t) !Int -> t;
Update2	:: !(List (List t)) !Int !Int !t -> List (List t);
AppendLists :: (List .a) u:(List .a) -> v:List .a, [u <= v];
FlattenList :: (List (List .a)) -> List .a;

InsertStringInList :: !String !(List String) -> List String;
RemoveStringFromList :: !String !(List String) -> List String;
UnionStringList :: !(List String) !(List String) -> List String;
StringOccurs :: !String !(List String) -> Bool;
SortStrings :: !(List String) -> List String;
EQStrings :: !(List String) !(List String) -> Bool;

StringToInt	:: !String -> Int;

StrictListToList :: !(List a) -> [a];
ListToStrictList :: [a] -> List a;
Map	:: !(s -> t) !(List s) -> List t;
